package gov.va.genisis2.service.impl;

import gov.va.genisis2.dao.IRequestDao;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestHistory;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.Source;
import gov.va.genisis2.service.IRequestService;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
/**
 * @author 586338
 * @author Getaneh Kassahun
 *
 */
@Service
public class RequestService implements IRequestService {
	
	/**
	 * The requestDao
	 * 
	 * */
	@Autowired
	private IRequestDao requestDao;

	/**
	 * This method is used to getRequestDao.
	 * @return this returns requestDao.
	 * 
	 * */
	public IRequestDao getRequestDao() {
		return requestDao;
	}

	/**
	 * This method is used to setRequestDao.
	 * @param requestDao The requestDao.
	 * 
	 * */
	public void setRequestDao(IRequestDao requestDao) {
		this.requestDao = requestDao;
	}
	
	/**
	 * This method is used to create request.
	 * @param request The request.
	 * @return int This returnes created request id.
	 */
	@Override
	public int createRequest(Request request) {
		return requestDao.createRequest(request);
	}

	/**
	 * This method is used to getRequestsByUID.
	 * @param uid The uid.
	 * @return this returnes list of requestes.
	 */
	@Override
	public List<Request> getRequestsByUID(String uid) {
		return requestDao.getRequestsByUID(uid);
	}

	/**
	 * This method is used to getRequestsById.
	 * @param id The id.
	 * @return Request This returns request.
	 */
	@Override
	public Request getRequestsById(int id) {
		return requestDao.getRequestsById(id);
	}

	/**
	 * This method is used to getAllRequests.
	 * @return this returns list of requestes.
	 */
	@Override
	public List<Request> getAllRequests() {
		return requestDao.getAllRequests();
	}

	/**
	 * This method is used to getAllRequestsByStudyApproval.
	 * @param studyApprovalId The studyApprovalId.
	 * @return this returns list of requests.
	 */
	@Override
	public List<Request> getAllRequestsByStudyApproval(int studyApprovalId) {
		return requestDao.getAllRequestsByStudyApproval(studyApprovalId);
	}
	
	/**
	 * This method is used to getAllRequestsByCommentHistory.
	 * @param commentHistoryId The commentHistoryId.
	 * @return this returns list of requests.
	 */
	@Override
	public List<Request> getAllRequestsByCommentHistory(int commentHistoryId) {
		return requestDao.getAllRequestsByCommentHistory(commentHistoryId);
	}
	
	/**
	 * This method is used to getAllRequestsByStaus.
	 * @param status The status.
	 * @return this returns list of requets.
	 */
	@Override
	public List<Request> getAllRequestsByStaus(String status) {
		return requestDao.getAllRequestsByStaus(status);
	}

	/**
	 * This method is used to submitOrModify entity.
	 * @param request The request.
	 * @return int This returns entity's id.
	 */
	@Override
	public int submitOrModify(Request request) {
		return requestDao.submitOrModify(request);
	}

	/**
	 * This method is used to getRequestType.
	 * @param id The id.
	 * @return RequestType This returns RequestType.
	 */
	@Override
	public RequestType getRequestType(int id) {

		return requestDao.getRequestType(id);
	}

	/**
	 * This method is used to getSource.
	 * @param id The id.
	 * @return Source This returns Source.
	 */
	@Override
	public Source getSource(int id) {
		return requestDao.getSource(id);
	}

	/**
	 * This method is used to submitOrModify RequestHistory.
	 * @param requestHistory The requestHistory.
	 * @return int This returns RequestHistory id.
	 * 
	 */
	@Override
	public int submitOrModify(RequestHistory requestHistory) {
		return requestDao.submitOrModify(requestHistory);
	}

	/**
	 * This method is used to getRequestHistoryById.
	 * @param requestId The requestId.
	 * @return this returns list of requests.
	 */
	@Override
	public List<RequestHistory> getRequestHistoryById(int requestId) {
	  return requestDao.getRequestHistoryById(requestId);
	}

	/**
	 * This method is used to getDataSources.
	 * @return this returns list of Source. 
	 */
	@Override
	public List<Source> getDataSources() {
		return requestDao.getDataSources();
	}

	/**
	 * This method is used to getRequestTypes.
	 * @return this returns list of RequestType.
	 */
	@Override
	public List<RequestType> getRequestTypes() {
		return requestDao.getRequestTypes();
	}

	/**
	 * This method is used to getRequestsByDataManager.
	 * @param uid The uid.
	 * @return this returns list of requests.
	 */
	@Override
	public List<Request> getRequestsByDataManagers(String uid) {
		return requestDao.getRequestsByDataManager(uid);
	}

	/**
	 * This method is used to getRequestsDataManagers.
	 * @param uid The uid.
	 * @return this returns list of requestes.
	 */
	@Override
	public List<Request> getRequestsDataManagers(String uid) {
	    return requestDao.getRequestsDataManagers(uid);
	}

	/**
	 * This method is used to getRequestsDataSourceManager.
	 * @param uid The uid.
	 * @return this returns list of requestes.
	 */
	@Override
	public List<Request> getRequestsDataSourceManagers(String uid) {
	    return requestDao.getRequestsDataSourceManagers(uid);
	}

	@Override
	public List<RequestHistory> getRequestHistoryByRequestIdAndStatus(
			int requestId, String status) {
	
		return requestDao.getRequestHistoryByRequestIdAndStatus(requestId, status);
	}
}
